<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Image_Full'))) {
		class WPBakeryShortCode_TS_VCSC_Image_Full extends WPBakeryShortCode {		
			public function singleParamHtmlHolder($param, $value, $settings = Array(), $atts = Array()) {
				$output 							= '';
				$param_name 						= isset($param['param_name']) ? $param['param_name'] : '';
				$heading 							= isset($param['heading']) ? $param['heading'] : '';
				$type 								= isset($param['type']) ? $param['type'] : '';
				$class 								= isset($param['class']) ? $param['class'] : '';
				if (isset($param['holder']) === true && in_array($param['holder'], array('div', 'span', 'p', 'pre', 'code'))) {
					$output .= '<'.$param['holder'].' class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '">'.$value.'</'.$param['holder'].'>';
				} else if (isset($param['holder']) === true && $param['holder'] == 'input') {
					$output .= '<'.$param['holder'].' readonly="true" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'.$value.'">';
				} else if (isset($param['holder']) === true && $param['holder'] == 'img') {
					$img = wpb_getImageBySize(array('attach_id' => (int) preg_replace('/[^\d]/', '', $value), 'thumb_size' => 'thumbnail'));
					$output .= ($img ? $img['thumbnail'] : '<img width="150" height="150" src="' . vc_asset_url( 'vc/blank.gif' ) . '" class="attachment-thumbnail ts_vcsc_holder_image"  data-name="' . $param_name . '" alt="" title="" style="display: none;" />' );
				} else if (isset($param['holder']) === true && $param['holder'] == 'imagelist') {
					$images_ids = empty($value) ? array() : explode(',', trim($value));
					$output .= '<ul style="margin-top: 5px;" class="attachment-thumbnails'.(empty($images_ids) ? ' image-exists' : '' ).'" data-name="' . $param_name . '">';
						foreach($images_ids as $image) {
							$img = wpb_getImageBySize(array( 'attach_id' => (int)$image, 'thumb_size' => 'thumbnail' ));
							$output .= ( $img ? '<li>'.$img['thumbnail'].'</li>' : '<li><img width="150" height="150" test="'.$image.'" src="' . WPBakeryVisualComposer::getInstance()->assetURL('vc/blank.gif') . '" class="attachment-thumbnail" alt="" title="" /></li>');
						}
					$output .= '</ul>';
				}				
				if (isset($param['admin_label']) && $param['admin_label'] === true) {
					$output .= '<span style="max-width: 100%; display: block;" class="vc_admin_label admin_label_'.$param['param_name'].(empty($value) ? ' hidden-label' : '').'"><label>'. $param['heading'] . '</label>: '.$value.'</span>';
				}				
				if ('dropdown' === $param['type'] && 'type' === $param_name) {
					$output .= '<a style="max-width: 100%; display: block;" href="#" class="column_edit_trigger" style="margin-bottom: 10px;">' . __( 'Add, Change or Remove Image(s)', "ts_visual_composer_extend" ) . '</a>';
				}	
				return $output;
			}
		}
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                          		=> __( "TS Image(s) Full", "ts_visual_composer_extend" ),
		"base"                          		=> "TS_VCSC_Image_Full",
		"icon"                          		=> "ts-composer-element-icon-image-full",
		"class"                         		=> "ts_vcsc_main_image_full",
		"category"                      		=> __( "Composium", "ts_visual_composer_extend" ),
		"description" 		            		=> __("Place a full width image (slider)", "ts_visual_composer_extend"),
		"admin_enqueue_js"            			=> "",
		"admin_enqueue_css"           			=> "",
		"params"                        		=> array(
			// Image Selection and Breakout
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_1",
				"seperator"                 	=> "Image(s) Selection",
			),
			array(
				"type" 							=> "dropdown",
				"heading" 						=> __( "Element Type", "ts_visual_composer_extend"),
				"param_name" 					=> "type",
				"value" 						=> array(
					__( "Single Image", "ts_visual_composer_extend")					=> "image",
					__( "Image Slideshow", "ts_visual_composer_extend")					=> "slideshow",
				),
				"description" 					=> __("Define what type of media element you want to show.", "ts_visual_composer_extend"),
				"admin_label"           		=> true,
			),				
			array(
				"type"                  		=> "attach_image",
				"holder" 						=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? "img" : ""),
				"heading"               		=> __( "Image", "ts_visual_composer_extend" ),
				"param_name"            		=> "image",
				"class"							=> "ts_vcsc_holder_image",
				"value"                 		=> "",
				"admin_label"           		=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? false : true),
				"description"           		=> __( "Select the image you want to use.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "type", 'value' => 'image' )
			),
			array(
				"type"                  		=> "attach_images",
				"heading"               		=> __( "Select Images", "ts_visual_composer_extend" ),
				"holder"						=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? "imagelist" : ""),
				"param_name"            		=> "slide_images",
				"value"                 		=> "",
				"description"       			=> __( "Select the images to be used for the background slideshow.", "ts_visual_composer_extend" ),
				"admin_label"           		=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorImagePreview == "true" ? false : true),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
			),
			array(
				"type"             	 			=> "switch_button",
				"heading"			    		=> __( "Add Custom ALT Attribute", "ts_visual_composer_extend" ),
				"param_name"		    		=> "attribute_alt",
				"value"				    		=> "false",
				"description"       			=> __( "Switch the toggle if you want to add a custom ALT attribute value, otherwise file name will be set.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "type", 'value' => 'image' )
			),
			array(
				"type"                  		=> "textfield",
				"heading"               		=> __( "Enter ALT Value", "ts_visual_composer_extend" ),
				"param_name"            		=> "attribute_alt_value",
				"value"                 		=> "",
				"description"           		=> __( "Enter a custom value for the ALT attribute for this image.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "attribute_alt", 'value' => 'true' )
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Full Width Breakouts", "ts_visual_composer_extend" ),
				"param_name"            		=> "break_parents",
				"value"                 		=> "6",
				"min"                   		=> "0",
				"max"                   		=> "99",
				"step"                  		=> "1",
				"unit"                  		=> '',
				"admin_label"           		=> true,
				"description"           		=> __( "Define the number of parent containers the image should attempt to break away from.", "ts_visual_composer_extend" ),
			),
			// Slideshow Settings
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_2",
				"seperator"                 	=> "Slideshow Settings",
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type" 							=> "dropdown",
				"class" 						=> "",
				"heading" 						=> __( "Use on Mobile", "ts_visual_composer_extend"),
				"param_name" 					=> "slide_mobile",
				"value" 						=> array(
					__( "Remove Element", "ts_visual_composer_extend")					=> "none",
					__( "Show Slideshow", "ts_visual_composer_extend")					=> "show",
					__( "Show First Image", "ts_visual_composer_extend")				=> "first",
					__( "Show Random Image", "ts_visual_composer_extend")				=> "random",
				),
				"description" 					=> __("Define if and how the slideshow should be shown on mobile devices.", "ts_visual_composer_extend"),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),				
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Maximum Slideshow Height", "ts_visual_composer_extend" ),
				"param_name"            		=> "slide_height",
				"value"                 		=> "600",
				"min"                   		=> "200",
				"max"                   		=> "1280",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Define the maximum height for the slideshow.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),				
			array(
				"type"              			=> "switch_button",
				"heading"           			=> __( "Shuffle Images", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_shuffle",
				"value"             			=> "false",
				"description"           		=> __( "Switch the toggle to shuffle the images for a random order.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "switch_button",
				"heading"           			=> __( "Show Controls", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_controls",
				"value"             			=> "true",
				"description"           		=> __( "Switch the toggle to show previous/next and/or auto-play controls for the background slideshow.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "switch_button",
				"heading"           			=> __( "Use AutoPlay", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_auto",
				"value"             			=> "true",
				"description"           		=> __( "Switch the toggle to use an autoplay feature for the background slideshow.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "nouislider",
				"heading"           			=> __( "Transition Delay", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_delay",
				"value"             			=> "5000",
				"min"               			=> "2000",
				"max"               			=> "20000",
				"step"              			=> "100",
				"unit"              			=> 'ms',
				"description"       			=> __( "Select the delay between each slide transition.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "slide_auto", 'value' => 'true' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "switch_button",
				"heading"           			=> __( "Show Progress Bar", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_bar",
				"value"             			=> "true",
				"description"           		=> __( "Switch the toggle to show a progressbar for the delay timer.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "slide_auto", 'value' => 'true' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "dropdown",
				"heading"           			=> __( "Transition Type", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_transition",
				"width"             			=> 300,
				"value"             			=> array(
					__( "Random", "ts_visual_composer_extend" )							=> "random",
					__( "Fade 1", "ts_visual_composer_extend" )							=> "fade",
					__( "Fade 2", "ts_visual_composer_extend" )							=> "fade2",
					__( "Blur 1", "ts_visual_composer_extend" )							=> "blur",
					__( "Blur 2", "ts_visual_composer_extend" )							=> "blur2",						
					__( "Flash 1", "ts_visual_composer_extend" )						=> "flash",
					__( "Flash 2", "ts_visual_composer_extend" )						=> "flash2",
					__( "Negative 1", "ts_visual_composer_extend" )						=> "negative",
					__( "Negative 2", "ts_visual_composer_extend" )						=> "negative2",						
					__( "Burn 1", "ts_visual_composer_extend" )							=> "burn",
					__( "Burn 2", "ts_visual_composer_extend" )							=> "burn2",
					__( "Slide Left 1", "ts_visual_composer_extend" )					=> "slideLeft",
					__( "Slide Left 2", "ts_visual_composer_extend" )					=> "slideLeft2",
					__( "Slide Right 1", "ts_visual_composer_extend" )					=> "slideRight",
					__( "Slide Right 2", "ts_visual_composer_extend" )					=> "slideRight2",						
					__( "Slide Up 1", "ts_visual_composer_extend" )						=> "slideUp",
					__( "Slide Up 2", "ts_visual_composer_extend" )						=> "slideUp2",
					__( "Slide Down 1", "ts_visual_composer_extend" )					=> "slideDown",
					__( "Slide Down 2", "ts_visual_composer_extend" )					=> "slideDown2",						
					__( "Zoom In 1", "ts_visual_composer_extend" )						=> "zoomIn",
					__( "Zoom In 2", "ts_visual_composer_extend" )						=> "zoomIn2",
					__( "Zoom Out 1", "ts_visual_composer_extend" )						=> "zoomOut",
					__( "Zoom Out 2", "ts_visual_composer_extend" )						=> "zoomOut2",						
					__( "Swirl Left 1", "ts_visual_composer_extend" )					=> "swirlLeft",
					__( "Swirl Left 2", "ts_visual_composer_extend" )					=> "swirlLeft2",
					__( "Swirl Right 1", "ts_visual_composer_extend" )					=> "swirlRight",
					__( "Swirl Right 2", "ts_visual_composer_extend" )					=> "swirlRight2",
				),
				"description"           		=> __( "Select the effect type to be used to transition between each slide.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "nouislider",
				"heading"           			=> __( "Transition Duration", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_switch",
				"value"             			=> "2000",
				"min"               			=> "50",
				"max"               			=> "4000",
				"step"              			=> "100",
				"unit"              			=> 'ms',
				"description"       			=> __( "Select the duration each slide transition should last.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "dropdown",
				"heading"           			=> __( "Animation Type", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_animation",
				"width"             			=> 300,
				"value"             			=> array(
					__( "None", "ts_visual_composer_extend" )							=> "null",
					__( "Random", "ts_visual_composer_extend" )							=> "random",
					__( "KenBurns Center", "ts_visual_composer_extend" )				=> "kenburns",
					__( "KenBurns Left", "ts_visual_composer_extend" )					=> "kenburnsLeft",
					__( "KenBurns Right", "ts_visual_composer_extend" )					=> "kenburnsRight",
					__( "KenBurns Up", "ts_visual_composer_extend" )					=> "kenburnsUp",						
					__( "KenBurns Up Left", "ts_visual_composer_extend" )				=> "kenburnsUpLeft",
					__( "KenBurns Up Right", "ts_visual_composer_extend" )				=> "kenburnsUpRight",
					__( "KenBurns Down", "ts_visual_composer_extend" )					=> "kenburnsDown",
					__( "KenBurns Down Left", "ts_visual_composer_extend" )				=> "kenburnsDownLeft",						
					__( "KenBurns Down Right", "ts_visual_composer_extend" )			=> "kenburnsDownRight",
				),
				"description"           		=> __( "Select the animation type to be applied to each slide while shown.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "dropdown",
				"heading"           			=> __( "Horizontal Position", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_halign",
				"width"             			=> 300,
				"value"             			=> array(
					__( "Center", "ts_visual_composer_extend" )							=> "center",
					__( "Top", "ts_visual_composer_extend" )							=> "top",
					__( "Right", "ts_visual_composer_extend" )							=> "right",
					__( "Bottom", "ts_visual_composer_extend" )							=> "bottom",
					__( "Left", "ts_visual_composer_extend" )							=> "left",
				),
				"description"           		=> __( "Select the horizontal position of each image in the slideshow.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			array(
				"type"              			=> "dropdown",
				"heading"           			=> __( "Vertical Position", "ts_visual_composer_extend" ),
				"param_name"        			=> "slide_valign",
				"width"             			=> 300,
				"value"             			=> array(
					__( "Center", "ts_visual_composer_extend" )							=> "center",
					__( "Top", "ts_visual_composer_extend" )							=> "top",
					__( "Right", "ts_visual_composer_extend" )							=> "right",
					__( "Bottom", "ts_visual_composer_extend" )							=> "bottom",
					__( "Left", "ts_visual_composer_extend" )							=> "left",
				),
				"description"           		=> __( "Select the vertical position of each image in the slideshow.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "type", 'value' => 'slideshow' ),
				"group" 						=> "Slideshow Settings",
			),
			// Image Link
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_3",
				"seperator"                 	=> "Image Link",
				"dependency"        			=> array( 'element' => "type", 'value' => 'image' ),
				"group" 						=> "Image Link",
			),
			array(
				"type" 							=> "dropdown",
				"heading" 						=> __( "Link Type", "ts_visual_composer_extend"),
				"param_name" 					=> "media_link_type",
				"value" 						=> array(
					__( "No Link", "ts_visual_composer_extend")							=> "none",
					__( "Link Full Element", "ts_visual_composer_extend")				=> "element",
					__( "Link Button", "ts_visual_composer_extend")						=> "flatbutton",
				),
				"description" 					=> __("Define what type of link you want to apply to the element.", "ts_visual_composer_extend"),
				"dependency"        			=> array( 'element' => "type", 'value' => 'image' ),
				"group" 						=> "Image Link",
			),
			array(
				"type" 							=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 						=> __("Link + Title", "ts_visual_composer_extend"),
				"param_name" 					=> "media_link_data",
				"description" 					=> __("Provide a link to another site/page for the element.", "ts_visual_composer_extend"),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => array('element', 'flatbutton') ),
				"group" 						=> "Image Link",
			),
			array(
				"type"                  		=> "textfield",
				"heading"               		=> __( "Button Text", "ts_visual_composer_extend" ),
				"param_name"            		=> "media_link_text",
				"value"                 		=> "Learn More!",
				"description"           		=> __( "Enter text to be used for the link button.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => 'flatbutton' ),
				"group" 						=> "Image Link",
			),
			array(
				"type" 							=> "icons_panel",
				'heading' 						=> __( 'Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 					=> 'media_link_icon',
				'value'							=> '',
				"settings" 						=> array(
					"emptyIcon" 						=> true,
					'emptyIconValue'					=> 'transparent',
					"type" 								=> 'extensions',
				),
				"description"       			=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => 'flatbutton' ),
				"group" 						=> "Image Link",
			),
			array(
				"type"                  		=> "dropdown",
				"heading"               		=> __( "Button Color Style", "ts_visual_composer_extend" ),
				"param_name"            		=> "media_link_standard",
				"width"                 		=> 300,
				"value"                 		=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Default_Colors,
				"description"           		=> __( "Select the general color style for button.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => 'flatbutton' ),
				"group" 						=> "Image Link",
			),
			array(
				"type"                  		=> "dropdown",
				"heading"               		=> __( "Button Hover Style", "ts_visual_composer_extend" ),
				"param_name"            		=> "media_link_hover",
				"width"                 		=> 300,
				"value"                 		=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Flat_Button_Hover_Colors,
				"description"           		=> __( "Select the general hover style for button.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => 'flatbutton' ),
				"group" 						=> "Image Link",
			),
			array(
				"type" 							=> "dropdown",
				"heading" 						=> __( "Button Width", "ts_visual_composer_extend"),
				"param_name" 					=> "media_link_width",
				"value" 						=> array(
					__( "Width in Percent", "ts_visual_composer_extend")					=> "percent",
					__( "Fixed Width in Pixels", "ts_visual_composer_extend")				=> "fixed",
				),
				"description" 					=> __("Define how the link button should be sized in relation to the element.", "ts_visual_composer_extend"),
				"dependency"        			=> array( 'element' => "media_link_type", 'value' => 'flatbutton' ),
				"group" 						=> "Image Link",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Width in Percent", "ts_visual_composer_extend" ),
				"param_name"            		=> "media_link_percent",
				"value"                 		=> "25",
				"min"                   		=> "10",
				"max"                   		=> "90",
				"step"                  		=> "1",
				"unit"                  		=> '%',
				"description"           		=> __( "Select width of the link button in percent of the element width.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "media_link_width", 'value' => 'percent' ),
				"group" 						=> "Image Link",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Fixed Width in Pixels", "ts_visual_composer_extend" ),
				"param_name"            		=> "media_link_fixed",
				"value"                 		=> "200",
				"min"                   		=> "100",
				"max"                   		=> "1024",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Select fixed width in pixels for the link button.", "ts_visual_composer_extend" ),
				"dependency"        			=> array( 'element' => "media_link_width", 'value' => 'fixed' ),
				"group" 						=> "Image Link",
			),
			// Image Shapes
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_4",
				"seperator"                 	=> "Image Shapes",
				"group" 						=> "Image Effects",
			),		
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Use Top Shape", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_top_on",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle if you want to apply a SVG shape to the top of the image.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Effects",
			),
			array(
				"type" 							=> "dropdown",
				"heading" 						=> __( "Top SVG Shape", "ts_visual_composer_extend" ),
				"param_name" 					=> "svg_top_style",
				"value" 						=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_List,
				"dependency" 					=> array(
					"element" 	=> "svg_top_on",
					"value" 	=> "true"
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Top SVG Height", "ts_visual_composer_extend" ),
				"param_name"            		=> "svg_top_height",
				"value"                 		=> "100",
				"min"                   		=> "0",
				"max"                   		=> "300",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"dependency" 					=> array(
					"element" 	=> "svg_top_on",
					"value" 	=> "true"
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Flip Top Shape", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_top_flip",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle if you want to flip the top SVG shape.", "ts_visual_composer_extend" ),
				"dependency" 					=> array(
					"element" 	=> "svg_top_style",
					"value" 	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_FlipMe
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Top SVG Position", "ts_visual_composer_extend" ),
				"param_name"            		=> "svg_top_position",
				"value"                 		=> "0",
				"min"                   		=> "-300",
				"max"                   		=> "300",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Define the exact position for the top SVG shape; you might have to adjust margins to avoid overlaps.", "ts_visual_composer_extend" ),
				"dependency" 					=> array(
					"element" 	=> "svg_bottom_style",
					"value" 	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_FlipMe
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "colorpicker",
				"heading"           			=> __( "Top SVG Color Main", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_top_color1",
				"value"            	 			=> "#ffffff",
				"dependency" 					=> array("element" 	=> "svg_bottom_on", "value" 	=> "true"),
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "colorpicker",
				"heading"           			=> __( "Top SVG Color Alternate", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_top_color2",
				"value"            	 			=> "#ededed",
				"dependency" 					=> array("element" 	=> "svg_top_style", "value" => array("14", "16")),
				"group" 						=> "Image Effects",
			),
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Use Bottom Shape", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_bottom_on",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle if you want to apply a SVG shape to the bottom of the image.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Effects",
			),
			array(
				"type" 							=> "dropdown",
				"heading" 						=> __( "Bottom SVG Shape", "ts_visual_composer_extend" ),
				"param_name" 					=> "svg_bottom_style",
				"value" 						=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_List,
				"dependency" 					=> array("element" 	=> "svg_bottom_on", "value" => "true"),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Bottom SVG Height", "ts_visual_composer_extend" ),
				"param_name"            		=> "svg_bottom_height",
				"value"                 		=> "100",
				"min"                   		=> "0",
				"max"                   		=> "300",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"dependency" 					=> array("element" 	=> "svg_bottom_on", "value" => "true"),
				"group" 						=> "Image Effects",
			),
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Flip Bottom Shape", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_bottom_flip",
				"value"             			=> "false",
				"on"							=> __( 'Yes', "ts_visual_composer_extend" ),
				"off"							=> __( 'No', "ts_visual_composer_extend" ),
				"style"							=> "select",
				"design"						=> "toggle-light",
				"description"       			=> __( "Switch the toggle if you want to flip the bottom SVG shape.", "ts_visual_composer_extend" ),
				"dependency" 					=> array(
					"element" 	=> "svg_bottom_style",
					"value" 	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_FlipMe
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Bottom SVG Position", "ts_visual_composer_extend" ),
				"param_name"            		=> "svg_bottom_position",
				"value"                 		=> "0",
				"min"                   		=> "-300",
				"max"                   		=> "300",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Define the exact position for the bottom SVG shape; you might have to adjust margins to avoid overlaps.", "ts_visual_composer_extend" ),
				"dependency" 					=> array(
					"element" 	=> "svg_bottom_style",
					"value" 	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_SVG_RowShapes_FlipMe
				),
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "colorpicker",
				"heading"           			=> __( "Bottom SVG Color Main", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_bottom_color1",
				"value"            	 			=> "#ffffff",
				"dependency" 					=> array("element" 	=> "svg_bottom_on", "value" => "true"),
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "colorpicker",
				"heading"           			=> __( "Bottom SVG Color Alternate", "ts_visual_composer_extend" ),
				"param_name"        			=> "svg_bottom_color2",
				"value"            	 			=> "#ededed",
				"dependency" 					=> array("element" 	=> "svg_bottom_style", "value" 	=> array("14", "16")),
				"group" 						=> "Image Effects",
			),
			// Image Effects
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_5",
				"seperator"                 	=> "Image Effects",
				"group" 						=> "Image Effects",
			),				
			array(
				"type" 							=> "dropdown",
				"class" 						=> "",
				"heading" 						=> __( "Blur Strength", "ts_visual_composer_extend"),
				"param_name" 					=> "blur_strength",
				"value" 						=> array(
					__( "None", "ts_visual_composer_extend")					=> "",
					__( "Small Blur", "ts_visual_composer_extend")				=> "ts-background-blur-small",
					__( "Medium Blur", "ts_visual_composer_extend")				=> "ts-background-blur-medium",
					__( "Strong Blur", "ts_visual_composer_extend")				=> "ts-background-blur-strong",
				),
				"description" 					=> __("Define an optional blur strength for the image.", "ts_visual_composer_extend"),
				"admin_label"           		=> true,
				"group" 						=> "Image Effects",
			),				
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Raster Overlay", "ts_visual_composer_extend" ),
				"param_name"        			=> "raster_use",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle if you want to use a raster overlay with the image.", "ts_visual_composer_extend" ),
				"admin_label"           		=> true,
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "background",
				"heading"           			=> __( "Raster Type", "ts_visual_composer_extend" ),
				"param_name"        			=> "raster_type",
				"height"             			=> 200,
				"pattern"             			=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Rasters_List,
				"value"							=> "",
				"encoding"          			=> "false",
				"asimage"						=> "false",
				"thumbsize"						=> 40,
				"description"       			=> __( "Select the raster pattern for the image effect.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "raster_use", 'value' => 'true' ),
				"group" 						=> "Image Effects",
			),		
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Color Overlay", "ts_visual_composer_extend" ),
				"param_name"        			=> "overlay_use",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle if you want to use a color overlay with the image; will only work with browser with RGBA support.", "ts_visual_composer_extend" ),
				"admin_label"           		=> true,
				"group" 						=> "Image Effects",
			),
			array(
				"type"              			=> "colorpicker",
				"heading"           			=> __( "Overlay Color", "ts_visual_composer_extend" ),
				"param_name"        			=> "overlay_color",
				"value"            	 			=> "rgba(30,115,190,0.25)",
				"description" 					=> __("Define the overlay color; use the alpha channel setting to define the opacity of the overlay.", "ts_visual_composer_extend"),
				"dependency" 					=> array("element" 	=> "overlay_use", "value" => "true"),
				"group" 						=> "Image Effects",
			),				
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Horizontal (X) Movement", "ts_visual_composer_extend" ),
				"param_name"        			=> "movement_x_allow",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle to have the image follow horizontal (x) movements.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "type", 'value' => 'image' ),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Horizontal Ratio", "ts_visual_composer_extend" ),
				"param_name"            		=> "movement_x_ratio",
				"value"                 		=> "20",
				"min"                   		=> "0",
				"max"                   		=> "100",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Define the ratio in pixels by how much the image is allowed to move horizontally.", "ts_visual_composer_extend" ),
				"dependency" 					=> array("element" 	=> "movement_x_allow", "value" 	=> "true"),
				"group" 						=> "Image Effects",
			),
			array(
				"type"							=> "switch_button",
				"heading"           			=> __( "Vertical (Y) Movement", "ts_visual_composer_extend" ),
				"param_name"        			=> "movement_y_allow",
				"value"             			=> "false",
				"description"       			=> __( "Switch the toggle to have the image follow vertical (y) movements.", "ts_visual_composer_extend" ),
				"dependency"            		=> array( 'element' => "type", 'value' => 'image' ),
				"group" 						=> "Image Effects",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Vertical Ratio", "ts_visual_composer_extend" ),
				"param_name"            		=> "movement_y_ratio",
				"value"                 		=> "20",
				"min"                   		=> "0",
				"max"                   		=> "100",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Define the ratio in pixels by how much the image is allowed to move vertically.", "ts_visual_composer_extend" ),
				"dependency" 					=> array("element" 	=> "movement_y_allow", "value" 	=> "true"),
				"group" 						=> "Image Effects",
			),				
			// Margin Settings
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_6",
				"seperator"                 	=> "Image Margins",
				"group" 						=> "Image Margins",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Margin: Left", "ts_visual_composer_extend" ),
				"param_name"            		=> "margin_left",
				"value"                 		=> "0",
				"min"                   		=> "-100",
				"max"                   		=> "100",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "If the image isn't exactly aligned, use left/right margins to adjust position.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Margins",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Margin: Right", "ts_visual_composer_extend" ),
				"param_name"            		=> "margin_right",
				"value"                 		=> "0",
				"min"                   		=> "-100",
				"max"                   		=> "100",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "If the image isn't exactly aligned, use left/right margins to adjust position.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Margins",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"            		=> "margin_top",
				"value"                 		=> "0",
				"min"                   		=> "-200",
				"max"                   		=> "400",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Select the top margin for your image.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Margins",
			),
			array(
				"type"                  		=> "nouislider",
				"heading"               		=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"            		=> "margin_bottom",
				"value"                 		=> "0",
				"min"                   		=> "-200",
				"max"                   		=> "400",
				"step"                  		=> "1",
				"unit"                  		=> 'px',
				"description"           		=> __( "Select the bottom margin for your image.", "ts_visual_composer_extend" ),
				"group" 						=> "Image Margins",
			),
			// Other Settings
			array(
				"type"                  		=> "seperator",
				"param_name"            		=> "seperator_7",
				"seperator"                 	=> "Other Settings",
				"group" 						=> "Other Settings",
			),
			array(
				"type"                  		=> "textfield",
				"heading"               		=> __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"            		=> "el_id",
				"value"                 		=> "",
				"description"           		=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 						=> "Other Settings",
			),
			array(
				"type"                  		=> "tag_editor",
				"heading"           			=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            		=> "el_class",
				"value"                 		=> "",
				"description"      				=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 						=> "Other Settings",
			),
		)
	);		
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>